/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.metrics;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.edison.health.StartupHealthIndicator;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.MessageReceiverNotification;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="synapse.edison.metrics", name={"enabled"}, havingValue="true")
@Component
public class ChannelMetricsReporter {
    static final String GAUGE_NAME = "kinesis_duration_behind_gauge";
    private final ConcurrentMap<String, AtomicLong> gauges = new ConcurrentHashMap<String, AtomicLong>();
    private final Optional<StartupHealthIndicator> startupHealthIndicator;

    public ChannelMetricsReporter(MeterRegistry meterRegistry, Optional<List<EventSource>> eventSources, Optional<StartupHealthIndicator> startupHealthIndicator) {
        eventSources.ifPresent(sources -> sources.forEach(eventSource -> {
            AtomicLong channel = (AtomicLong)meterRegistry.gauge(GAUGE_NAME, (Iterable)ImmutableList.of((Object)Tag.of((String)"channel", (String)eventSource.getChannelName())), (Number)new AtomicLong(0L));
            this.gauges.put(eventSource.getChannelName(), channel);
        }));
        this.startupHealthIndicator = startupHealthIndicator;
    }

    @EventListener
    public void messageReceived(MessageReceiverNotification messageReceiverNotification) {
        AtomicLong atomicLong = (AtomicLong)this.gauges.get(messageReceiverNotification.getChannelName());
        if (this.isHealthyOrHealthUnavailable() && messageReceiverNotification.getChannelDurationBehind().isPresent()) {
            atomicLong.set(((ChannelDurationBehind)messageReceiverNotification.getChannelDurationBehind().get()).getDurationBehind().toMillis());
        }
    }

    private boolean isHealthyOrHealthUnavailable() {
        return !this.startupHealthIndicator.isPresent() || this.startupHealthIndicator.get().health().getStatus().equals((Object)Status.UP);
    }
}

