/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import de.otto.synapse.edison.trace.TraceEntry;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageEndpoint;
import java.util.Objects;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageTrace {
    private final Queue<TraceEntry> traceEntries;
    private final int capacity;
    private final ConcurrentMap<String, Boolean> senders = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> receivers = new ConcurrentHashMap<String, Boolean>();

    public MessageTrace(int capacity) {
        this.traceEntries = EvictingQueue.create((int)capacity);
        this.capacity = capacity;
    }

    public SortedSet<String> getSenderChannels() {
        return Sets.newTreeSet(this.senders.keySet());
    }

    public SortedSet<String> getReceiverChannels() {
        return Sets.newTreeSet(this.receivers.keySet());
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized void add(TraceEntry traceEntry) {
        this.traceEntries.add(traceEntry);
        if (traceEntry.getEndpointType() == EndpointType.RECEIVER) {
            this.receivers.putIfAbsent(traceEntry.getChannelName(), Boolean.TRUE);
        } else if (traceEntry.getEndpointType() == EndpointType.SENDER) {
            this.senders.putIfAbsent(traceEntry.getChannelName(), Boolean.TRUE);
        }
    }

    public synchronized Stream<TraceEntry> stream() {
        return ImmutableList.copyOf(this.traceEntries).stream();
    }

    public synchronized Stream<TraceEntry> stream(String channelName, EndpointType endpointType) {
        return ImmutableList.copyOf(this.traceEntries).stream().filter(traceEntry -> traceEntry.getChannelName().equals(channelName) && traceEntry.getEndpointType().equals((Object)endpointType));
    }

    private static final class RegisteredEndpoints {
        private final String channelName;
        private final EndpointType endpointType;

        RegisteredEndpoints(MessageEndpoint messageEndpoint) {
            this.channelName = messageEndpoint.getChannelName();
            this.endpointType = messageEndpoint.getEndpointType();
        }

        String getChannelName() {
            return this.channelName;
        }

        EndpointType getEndpointType() {
            return this.endpointType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegisteredEndpoints that = (RegisteredEndpoints)o;
            return Objects.equals(this.channelName, that.channelName) && this.endpointType == that.endpointType;
        }

        public int hashCode() {
            return Objects.hash(this.channelName, this.endpointType);
        }

        public String toString() {
            return "RegisteredEndpoints{channelName='" + this.channelName + '\'' + ", endpointType=" + this.endpointType + '}';
        }
    }
}

