/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.health;

import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.SnapshotReaderNotification;
import de.otto.synapse.info.SnapshotReaderStatus;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="synapse.edison.health", name={"snapshotreader.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={EventSource.class})
public class SnapshotReaderHealthIndicator
implements HealthIndicator {
    private volatile Health health = Health.up().build();

    @EventListener
    public void on(SnapshotReaderNotification notification) {
        if (notification.getStatus() == SnapshotReaderStatus.FAILED) {
            this.health = Health.down().withDetail("channelName", (Object)notification.getChannelName()).withDetail("message", (Object)notification.getMessage()).build();
        }
    }

    public Health health() {
        return this.health;
    }
}

