/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.TextMessage;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class TraceEntry
implements Serializable {
    private static AtomicLong nextSequenceNumber = new AtomicLong(0L);
    private final long sequenceNumber = nextSequenceNumber.getAndIncrement();
    private final Instant timestamp = Instant.now();
    private final String channelName;
    private final EndpointType endpointType;
    private final TextMessage message;

    public TraceEntry(String channelName, EndpointType endpointType, TextMessage message) {
        this.channelName = channelName;
        this.endpointType = endpointType;
        this.message = message;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public TextMessage getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceEntry that = (TraceEntry)o;
        return this.sequenceNumber == that.sequenceNumber && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.channelName, that.channelName) && this.endpointType == that.endpointType && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceNumber, this.timestamp, this.channelName, this.endpointType, this.message);
    }

    public String toString() {
        return "TraceEntry{sequenceNumber=" + this.sequenceNumber + ", timestamp=" + this.timestamp + ", channelName='" + this.channelName + '\'' + ", endpointType=" + this.endpointType + ", message=" + this.message + '}';
    }
}

