/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.statusdetail;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.synapse.info.MessageReceiverEndpointInfoProvider;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageReceiverStatusDetailIndicator
implements StatusDetailIndicator {
    private final MessageReceiverEndpointInfoProvider provider;

    @Autowired
    public MessageReceiverStatusDetailIndicator(MessageReceiverEndpointInfoProvider provider) {
        this.provider = provider;
    }

    public List<StatusDetail> statusDetails() {
        return this.provider.getInfos().stream().map(channelInfo -> this.createStatusDetail(this.statusOf(channelInfo.getStatus()), channelInfo.getChannelName(), channelInfo.getMessage())).collect(Collectors.toList());
    }

    private Status statusOf(MessageReceiverStatus status) {
        return status != MessageReceiverStatus.FAILED ? Status.OK : Status.ERROR;
    }

    private StatusDetail createStatusDetail(Status status, String name, String message) {
        return StatusDetail.statusDetail((String)name, (Status)status, (String)message);
    }
}

