/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.journal;

import com.google.common.collect.ImmutableMap;
import de.otto.synapse.journal.Journal;
import de.otto.synapse.journal.JournalRegistry;
import de.otto.synapse.messagestore.MessageStoreEntry;
import de.otto.synapse.state.StateRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ConditionalOnBean(value={StateRepository.class})
@ConditionalOnProperty(prefix="synapse.edison.state.ui", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JournalUiController {
    private final JournalRegistry journals;

    public JournalUiController(JournalRegistry journals) {
        this.journals = journals;
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/journals/{repositoryName}/{entityId}"}, produces={"text/html"})
    public ModelAndView getEntityJournalHtml(@PathVariable String repositoryName, @PathVariable String entityId) {
        if (this.journals.hasJournal(repositoryName)) {
            final AtomicLong nextSequenceNumber = new AtomicLong(0L);
            Stream entries = ((Journal)this.journals.getJournal(repositoryName).get()).getJournalFor(entityId);
            return new ModelAndView("journal", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repositoryName, (Object)"entityId", (Object)entityId, (Object)"messages", entries.map(message -> new HashMap((MessageStoreEntry)message){
                final /* synthetic */ MessageStoreEntry val$message;
                {
                    this.val$message = messageStoreEntry;
                    this.put("sequenceNumber", nextSequenceNumber.getAndIncrement());
                    this.put("channelName", this.val$message.getChannelName());
                    this.put("key", this.val$message.getTextMessage().getKey().toString());
                    this.put("header", this.val$message.getTextMessage().getHeader());
                    this.put("payload", this.val$message.getTextMessage().getPayload());
                }
            }).collect(Collectors.toList())));
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No such Journal " + repositoryName);
    }
}

