/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.journal;

import de.otto.synapse.message.Header;
import de.otto.synapse.messagestore.MessageStoreEntry;
import de.otto.synapse.translator.ObjectMappers;
import java.util.Map;
import java.util.Objects;

public class MessageStoreEntryRepresentation {
    private final String key;
    private final Header header;
    private final Object payload;
    private final String channelName;

    public MessageStoreEntryRepresentation(MessageStoreEntry entry) {
        Object p;
        this.channelName = entry.getChannelName();
        this.key = entry.getTextMessage().getKey().toString();
        this.header = entry.getTextMessage().getHeader();
        try {
            p = ObjectMappers.currentObjectMapper().readValue((String)entry.getTextMessage().getPayload(), Map.class);
        }
        catch (Exception e) {
            p = entry.getTextMessage().getPayload();
        }
        this.payload = p;
    }

    public String getKey() {
        return this.key;
    }

    public Header getHeader() {
        return this.header;
    }

    public Object getPayload() {
        return this.payload;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageStoreEntryRepresentation)) {
            return false;
        }
        MessageStoreEntryRepresentation that = (MessageStoreEntryRepresentation)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.header, that.header) && Objects.equals(this.payload, that.payload) && Objects.equals(this.channelName, that.channelName);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.header, this.payload, this.channelName);
    }

    public String toString() {
        return "MessageStoreEntryRepresentation{key='" + this.key + '\'' + ", header=" + this.header + ", payload=" + this.payload + ", channelName='" + this.channelName + '\'' + '}';
    }
}

