/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.health;

import de.otto.synapse.info.MessageReceiverNotification;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.event.EventListener;

public abstract class AbstractChannelHealthIndicator
implements HealthIndicator {
    public static final long TEN_SECONDS = 10000L;
    private Set<String> allChannels;
    private Set<String> healthyChannels;

    protected AbstractChannelHealthIndicator(Set<String> allChannels) {
        this.allChannels = allChannels;
        this.healthyChannels = ConcurrentHashMap.newKeySet();
    }

    @EventListener
    public void on(MessageReceiverNotification notification) {
        if (notification.getStatus() == MessageReceiverStatus.RUNNING) {
            notification.getChannelDurationBehind().ifPresent(channelDurationBehind -> {
                if (channelDurationBehind.getDurationBehind().toMillis() <= 10000L) {
                    this.healthyChannels.add(notification.getChannelName());
                }
            });
        }
    }

    public Health health() {
        Health.Builder healthBuilder = this.healthyChannels.containsAll(this.allChannels) ? Health.up().withDetail("message", (Object)"All channels up to date") : Health.down().withDetail("message", (Object)"Channel(s) not yet up to date");
        return healthBuilder.build();
    }
}

