/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.journal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.edison.hal.HalRepresentation;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import de.otto.synapse.edison.journal.JournalHalRepresentation;
import de.otto.synapse.edison.journal.MessageStoreEntryRepresentation;
import de.otto.synapse.edison.state.EdisonStateRepositoryUiProperties;
import de.otto.synapse.journal.JournalRegistry;
import de.otto.synapse.state.StateRepository;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnBean(value={StateRepository.class})
@ConditionalOnProperty(prefix="synapse.edison.state.ui", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JournalRestController {
    private final JournalRegistry journals;
    private final ImmutableMap<String, StateRepository<?>> stateRepositories;
    private final String managementBasePath;

    public JournalRestController(List<StateRepository<?>> stateRepositories, JournalRegistry journals, EdisonStateRepositoryUiProperties properties, @Value(value="${edison.application.management.base-path:internal}") String managementBasePath) {
        this.stateRepositories = Maps.uniqueIndex((Iterable)stateRepositories.stream().filter(repo -> !properties.getExcluded().contains(repo.getName())).collect(Collectors.toSet()), StateRepository::getName);
        this.journals = journals;
        this.managementBasePath = managementBasePath;
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/journals/{repositoryName}/{entityId}"}, produces={"application/hal+json", "application/json"})
    @ResponseBody
    public HalRepresentation getEntityJournalJson(@PathVariable String repositoryName, @PathVariable String entityId, UriComponentsBuilder uriComponentsBuilder) {
        String baseUri = uriComponentsBuilder.pathSegment(new String[]{this.managementBasePath}).toUriString();
        String selfUri = baseUri + "/journals/" + repositoryName + "/" + entityId;
        if (this.journals.hasJournal(repositoryName)) {
            List<MessageStoreEntryRepresentation> messages = this.journals.getJournal(repositoryName).map(journal -> journal.getJournalFor(entityId).map(MessageStoreEntryRepresentation::new).collect(Collectors.toList())).orElse(Collections.emptyList());
            Links.Builder links = Links.linkingTo().self(selfUri);
            if (this.stateRepositories.containsKey((Object)repositoryName)) {
                links.single(Link.link((String)"working-copy", (String)(baseUri + "/staterepositories/" + repositoryName + "/" + entityId)), new Link[0]).single(Link.collection((String)(baseUri + "/staterepositories/" + repositoryName + "{?page,pageSize}")), new Link[0]);
            }
            return new JournalHalRepresentation(links.build(), messages);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No such Journal " + repositoryName);
    }
}

