/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.metrics;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.edison.health.StartupHealthIndicator;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.MessageReceiverNotification;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="synapse.edison.metrics", name={"enabled"}, havingValue="true")
@Component
public class ChannelMetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelMetricsReporter.class);
    static final String GAUGE_NAME = "kinesis_duration_behind_gauge";
    private final ConcurrentMap<String, AtomicLong> gauges = new ConcurrentHashMap<String, AtomicLong>();
    private final Optional<StartupHealthIndicator> startupHealthIndicator;
    private final MeterRegistry meterRegistry;

    public ChannelMetricsReporter(MeterRegistry meterRegistry, Optional<List<EventSource>> eventSources, Optional<StartupHealthIndicator> startupHealthIndicator) {
        this.meterRegistry = meterRegistry;
        eventSources.ifPresent(sources -> sources.forEach(eventSource -> this.createChannelNameGauge(eventSource.getChannelName())));
        this.startupHealthIndicator = startupHealthIndicator;
    }

    @EventListener
    public void messageReceived(MessageReceiverNotification messageReceiverNotification) {
        String channelName = messageReceiverNotification.getChannelName();
        AtomicLong atomicLong = (AtomicLong)this.gauges.get(channelName);
        if (this.isHealthyOrHealthUnavailable() && messageReceiverNotification.getChannelDurationBehind().isPresent()) {
            if (atomicLong == null) {
                LOG.warn("gauge for {} could not be found, this is likely due to a programmatically configured eventsource. Recreating gauge", (Object)channelName);
                this.createChannelNameGauge(channelName);
                atomicLong = (AtomicLong)this.gauges.get(channelName);
            }
            atomicLong.set(((ChannelDurationBehind)messageReceiverNotification.getChannelDurationBehind().get()).getDurationBehind().toMillis());
        }
    }

    private void createChannelNameGauge(String channelName) {
        AtomicLong channel = (AtomicLong)this.meterRegistry.gauge(GAUGE_NAME, (Iterable)ImmutableList.of((Object)Tag.of((String)"channel", (String)channelName)), (Number)new AtomicLong(0L));
        this.gauges.put(channelName, channel);
    }

    private boolean isHealthyOrHealthUnavailable() {
        return !this.startupHealthIndicator.isPresent() || this.startupHealthIndicator.get().health().getStatus().equals((Object)Status.UP);
    }
}

