/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.state;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.edison.hal.HalRepresentation;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import de.otto.edison.hal.paging.NumberedPaging;
import de.otto.edison.hal.paging.PagingRel;
import de.otto.synapse.edison.state.EdisonStateRepositoryUiProperties;
import de.otto.synapse.edison.state.EntityHalRepresentation;
import de.otto.synapse.journal.JournalRegistry;
import de.otto.synapse.state.StateRepository;
import jakarta.servlet.http.HttpServletRequest;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnBean(value={StateRepository.class})
@ConditionalOnProperty(prefix="synapse.edison.state.ui", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StateRepositoryRestController {
    private final JournalRegistry journals;
    private final ImmutableMap<String, StateRepository<?>> stateRepositories;
    private final String managementBasePath;

    public StateRepositoryRestController(List<StateRepository<?>> stateRepositories, JournalRegistry journals, EdisonStateRepositoryUiProperties properties, @Value(value="${edison.application.management.base-path:internal}") String managementBasePath) {
        this.stateRepositories = Maps.uniqueIndex((Iterable)stateRepositories.stream().filter(repo -> !properties.getExcluded().contains(repo.getName())).collect(Collectors.toSet()), StateRepository::getName);
        this.journals = journals;
        this.managementBasePath = managementBasePath;
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories"}, produces={"application/hal+json", "application/json"})
    @ResponseBody
    public HalRepresentation getStateRepositories(HttpServletRequest request) {
        String selfHref = request.getRequestURL().toString();
        List<Link> itemLinks = this.itemLinks(selfHref);
        return new HalRepresentation(Links.linkingTo().self(selfHref).array(itemLinks).build());
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories/{repositoryName}"}, produces={"application/hal+json", "application/json"})
    @ResponseBody
    public HalRepresentation getStateRepository(@PathVariable String repositoryName, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="100") int pageSize, UriComponentsBuilder uriComponentsBuilder) {
        if (this.stateRepositories.containsKey((Object)repositoryName)) {
            UriComponentsBuilder baseUriBuilder = uriComponentsBuilder.pathSegment(new String[]{this.managementBasePath}).path("/staterepositories");
            UriTemplate repositoriesUri = UriTemplate.fromTemplate((String)baseUriBuilder.toUriString());
            UriTemplate repositoryUri = UriTemplate.fromTemplate((String)(baseUriBuilder.toUriString() + "/" + repositoryName + "{?page,pageSize}"));
            UriTemplate entityUri = UriTemplate.fromTemplate((String)(baseUriBuilder.toUriString() + "/" + repositoryName + "/{entityId}"));
            StateRepository stateRepository = (StateRepository)this.stateRepositories.get((Object)repositoryName);
            Set allEntityIds = stateRepository.keySet();
            List<String> entityPageIds = allEntityIds.stream().skip(page * pageSize).limit(pageSize).collect(Collectors.toList());
            Links pagingLinks = pageSize > 0 ? NumberedPaging.zeroBasedNumberedPaging((int)page, (int)pageSize, (int)((int)stateRepository.size())).links(repositoryUri, EnumSet.allOf(PagingRel.class)) : Links.emptyLinks();
            List<Link> itemLinks = this.entityItemLinks(entityUri, entityPageIds);
            return new HalRepresentation(Links.linkingTo().with(pagingLinks).single(Link.collection((String)repositoriesUri.expand()), new Link[0]).array(itemLinks).build());
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No such StateRepository " + repositoryName);
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories/{repositoryName}/{entityId}"}, produces={"application/hal+json", "application/json"})
    @ResponseBody
    public HalRepresentation getEntityJson(@PathVariable String repositoryName, @PathVariable String entityId, UriComponentsBuilder uriComponentsBuilder) {
        String baseUri = uriComponentsBuilder.pathSegment(new String[]{this.managementBasePath}).toUriString();
        if (this.stateRepositories.containsKey((Object)repositoryName)) {
            StateRepository stateRepository = (StateRepository)this.stateRepositories.get((Object)repositoryName);
            Links.Builder links = Links.linkingTo().self(baseUri + "/" + repositoryName + "/staterepositories/" + entityId).single(Link.collection((String)(baseUri + "/staterepositories/" + repositoryName + "{?page,pageSize}")), new Link[0]);
            if (this.journals.hasJournal(repositoryName)) {
                links.single(Link.link((String)"working-copy-of", (String)(baseUri + "/journals/" + repositoryName + "/" + entityId)), new Link[0]);
            }
            return new EntityHalRepresentation(links.build(), stateRepository.get(entityId));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No such StateRepository " + repositoryName);
    }

    private List<Link> entityItemLinks(UriTemplate uriTemplate, List<String> entityIds) {
        return entityIds.stream().map(key -> Link.item((String)uriTemplate.set("entityId", key).expand())).collect(Collectors.toList());
    }

    private List<Link> itemLinks(String baseHref) {
        return this.stateRepositories.keySet().stream().sorted().map(itemId -> Link.item((String)this.itemHref(baseHref, (String)itemId))).collect(Collectors.toList());
    }

    private String itemHref(String baseHref, String itemId) {
        return baseHref.endsWith("/") ? baseHref + itemId : baseHref + "/" + itemId;
    }
}

