/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.history;

import jakarta.annotation.Nullable;
import java.util.Objects;

public class Diff {
    private final String key;
    private final Object previousValue;
    private final Object newValue;

    public Diff(String key, Object previousValue, Object newValue) {
        this.key = key;
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public Object getPreviousValue() {
        return this.previousValue;
    }

    @Nullable
    public Object getNewValue() {
        return this.newValue;
    }

    public boolean isEqual() {
        return Objects.equals(this.previousValue, this.newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Diff diff = (Diff)o;
        return Objects.equals(this.key, diff.key) && Objects.equals(this.previousValue, diff.previousValue) && Objects.equals(this.newValue, diff.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.previousValue, this.newValue);
    }

    public String toString() {
        return "Diff{key='" + this.key + "', previousValue=" + this.previousValue + ", newValue=" + this.newValue + "}";
    }
}

