/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.state;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.synapse.state.DelegatingStateRepository;
import de.otto.synapse.state.StateRepository;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.SmartLifecycle;

public class StatusIndicatingStateRepository<T>
extends DelegatingStateRepository<T>
implements StatusDetailIndicator,
SmartLifecycle {
    private final String repositoryName;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public StatusIndicatingStateRepository(StateRepository<T> stateRepository, String repositoryName) {
        super(stateRepository);
        this.repositoryName = repositoryName;
    }

    public List<StatusDetail> statusDetails() {
        if (this.running.get()) {
            return Collections.singletonList(StatusDetail.statusDetail((String)("StateRepository '" + this.repositoryName + "'"), (Status)Status.OK, (String)String.format("StateRepository contains %s elements.", this.size())));
        }
        return Collections.emptyList();
    }

    public void close() throws Exception {
        this.running.set(false);
        super.close();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }
}

