/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.health;

import de.otto.synapse.consumer.EventSourceNotification;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class EventSourcingHealthIndicator
implements HealthIndicator {
    private Health health = Health.up().build();

    @EventListener
    public void onEventSourceNotification(EventSourceNotification eventSourceNotification) {
        if (eventSourceNotification.getStatus() == EventSourceNotification.Status.FAILED) {
            this.health = Health.down().withDetail("message", (Object)eventSourceNotification.getMessage()).withDetail("stream", (Object)eventSourceNotification.getStreamName()).build();
        }
    }

    public Health health() {
        return this.health;
    }
}

