/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.statusdetail;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.synapse.consumer.EventSourceNotification;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class EventSourcingStatusDetailIndicator
implements StatusDetailIndicator {
    private Map<String, Long> startingTimeMap = new HashMap<String, Long>();
    private Map<String, StatusDetail> statusDetailMap = new HashMap<String, StatusDetail>();
    private Clock clock;

    @Autowired
    public EventSourcingStatusDetailIndicator() {
        this.clock = Clock.systemDefaultZone();
    }

    EventSourcingStatusDetailIndicator(Clock clock) {
        this.clock = clock;
    }

    @EventListener
    public void onEventSourceNotification(EventSourceNotification eventSourceNotification) {
        String streamName = eventSourceNotification.getStreamName();
        StatusDetail statusDetail = this.createStatusDetail(Status.WARNING, streamName, "Should not happen.");
        switch (eventSourceNotification.getStatus()) {
            case FAILED: {
                statusDetail = this.createStatusDetail(Status.ERROR, streamName, eventSourceNotification.getMessage());
                break;
            }
            case STARTED: {
                statusDetail = this.createStatusDetail(Status.OK, streamName, eventSourceNotification.getMessage());
                this.startingTimeMap.put(this.eventSourceAndStreamName(eventSourceNotification), this.clock.millis());
                break;
            }
            case FINISHED: {
                long runtime = this.clock.millis() - this.startingTimeMap.get(this.eventSourceAndStreamName(eventSourceNotification));
                statusDetail = this.createStatusDetail(Status.OK, streamName, String.format("%s Finished consumption after %d seconds.", eventSourceNotification.getMessage(), runtime / 1000L));
            }
        }
        this.statusDetailMap.put(streamName, statusDetail);
    }

    private String eventSourceAndStreamName(EventSourceNotification eventSourceNotification) {
        return eventSourceNotification.getEventSourceName() + ":" + eventSourceNotification.getStreamName();
    }

    public StatusDetail statusDetail() {
        return null;
    }

    public List<StatusDetail> statusDetails() {
        return new ArrayList<StatusDetail>(this.statusDetailMap.values());
    }

    private StatusDetail createStatusDetail(Status status, String name, String message) {
        return StatusDetail.statusDetail((String)name, (Status)status, (String)message);
    }
}

