/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import de.otto.synapse.edison.trace.MessageTraces;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.messagestore.InMemoryRingBufferMessageStore;
import de.otto.synapse.messagestore.MessageStore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="synapse.edison.trace", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MessageTraceAutoConfiguration {
    @Autowired
    private MessageInterceptorRegistry interceptorRegistry;
    @Value(value="${synapse.edison.trace.capacity:100}")
    private int capacity = 100;

    @Bean
    @ConditionalOnMissingBean
    public MessageTraces traceMessageStore(Optional<List<MessageLogReceiverEndpoint>> messageLogReceiverEndpoints, Optional<List<MessageSenderEndpoint>> senderEndpoints) {
        return new MessageTraces(this.receiverStoresFor(messageLogReceiverEndpoints.orElse(Collections.emptyList())), this.senderStoresFor(senderEndpoints.orElse(Collections.emptyList())));
    }

    private ImmutableMap<String, MessageStore> receiverStoresFor(List<MessageLogReceiverEndpoint> messageLogReceiverEndpoints) {
        ImmutableBiMap.Builder receiverStores = ImmutableBiMap.builder();
        messageLogReceiverEndpoints.forEach(arg_0 -> this.lambda$receiverStoresFor$1((ImmutableMap.Builder)receiverStores, arg_0));
        return receiverStores.build();
    }

    private ImmutableMap<String, MessageStore> senderStoresFor(List<MessageSenderEndpoint> senderEndpoints) {
        ImmutableBiMap.Builder senderStores = ImmutableBiMap.builder();
        senderEndpoints.forEach(arg_0 -> this.lambda$senderStoresFor$3((ImmutableMap.Builder)senderStores, arg_0));
        return senderStores.build();
    }

    private /* synthetic */ void lambda$senderStoresFor$3(ImmutableMap.Builder senderStores, MessageSenderEndpoint senderEndpoint) {
        InMemoryRingBufferMessageStore messageStore = new InMemoryRingBufferMessageStore(this.capacity);
        senderEndpoint.getInterceptorChain().register(message -> {
            messageStore.add(message);
            return message;
        });
        senderStores.put((Object)senderEndpoint.getChannelName(), (Object)messageStore);
    }

    private /* synthetic */ void lambda$receiverStoresFor$1(ImmutableMap.Builder receiverStores, MessageLogReceiverEndpoint messageLogReceiverEndpoint) {
        InMemoryRingBufferMessageStore messageStore = new InMemoryRingBufferMessageStore(this.capacity);
        messageLogReceiverEndpoint.getInterceptorChain().register(message -> {
            messageStore.add(message);
            return message;
        });
        receiverStores.put((Object)messageLogReceiverEndpoint.getChannelName(), (Object)messageStore);
    }
}

