/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.statusdetail;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.synapse.eventsource.EventSourceNotification;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class EventSourcingStatusDetailIndicator
implements StatusDetailIndicator {
    private SortedMap<String, Long> startingTimeMap = new TreeMap<String, Long>();
    private SortedMap<String, StatusDetail> statusDetailMap = new TreeMap<String, StatusDetail>();
    private Clock clock;

    @Autowired
    public EventSourcingStatusDetailIndicator() {
        this.clock = Clock.systemDefaultZone();
    }

    EventSourcingStatusDetailIndicator(Clock clock) {
        this.clock = clock;
    }

    @EventListener
    public void onEventSourceNotification(EventSourceNotification eventSourceNotification) {
        String channelName = eventSourceNotification.getChannelName();
        StatusDetail statusDetail = this.createStatusDetail(Status.WARNING, channelName, "Should not happen.");
        switch (eventSourceNotification.getStatus()) {
            case FAILED: {
                statusDetail = this.createStatusDetail(Status.ERROR, channelName, eventSourceNotification.getMessage());
                break;
            }
            case STARTED: {
                statusDetail = this.createStatusDetail(Status.OK, channelName, eventSourceNotification.getMessage());
                this.startingTimeMap.put(this.eventSourceAndChannelName(eventSourceNotification), this.clock.millis());
                break;
            }
            case FINISHED: {
                long runtime = this.clock.millis() - (Long)this.startingTimeMap.get(this.eventSourceAndChannelName(eventSourceNotification));
                statusDetail = this.createStatusDetail(Status.OK, channelName, String.format("%s Finished consumption after %d seconds.", eventSourceNotification.getMessage(), runtime / 1000L));
            }
        }
        this.statusDetailMap.put(channelName, statusDetail);
    }

    private String eventSourceAndChannelName(EventSourceNotification eventSourceNotification) {
        return eventSourceNotification.getEventSourceName() + ":" + eventSourceNotification.getChannelName();
    }

    public StatusDetail statusDetail() {
        return null;
    }

    public List<StatusDetail> statusDetails() {
        return new ArrayList<StatusDetail>(this.statusDetailMap.values());
    }

    private StatusDetail createStatusDetail(Status status, String name, String message) {
        return StatusDetail.statusDetail((String)name, (Status)status, (String)message);
    }
}

