/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.health;

import de.otto.synapse.info.MessageReceiverNotification;
import de.otto.synapse.info.MessageReceiverStatus;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
public class MessageReceiverEndpointHealthIndicator
implements HealthIndicator {
    private volatile Health health = Health.up().build();

    @EventListener
    public void on(MessageReceiverNotification messageEndpointNotification) {
        if (messageEndpointNotification.getStatus() == MessageReceiverStatus.FAILED) {
            this.health = Health.down().withDetail("channelName", (Object)messageEndpointNotification.getChannelName()).withDetail("message", (Object)messageEndpointNotification.getMessage()).build();
        }
    }

    public Health health() {
        return this.health;
    }
}

