/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import de.otto.edison.navigation.NavBar;
import de.otto.edison.navigation.NavBarItem;
import de.otto.synapse.edison.trace.MessageTraces;
import de.otto.synapse.message.Message;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ConditionalOnBean(name={"traceMessageStore"})
public class MessageTraceController {
    private final MessageTraces messageTraces;

    @Autowired
    MessageTraceController(MessageTraces messageTraces, NavBar rightNavBar, ManagementServerProperties managementServerProperties) {
        this.messageTraces = messageTraces;
        rightNavBar.register(NavBarItem.navBarItem((int)10, (String)"Message Trace", (String)String.format("%s/message-trace", managementServerProperties.getContextPath())));
    }

    @GetMapping(path={"${management.context-path}/messagetrace/receivers/{channelName}"}, produces={"text/html"})
    @ResponseBody
    public String getMessageTrace(@PathVariable String channelName) {
        return this.messageTraces.getReceiverTrace(channelName).stream().map(Message::toString).collect(Collectors.joining("<li>", "<ol>", "</ol>"));
    }
}

