/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.statusdetail;

import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.MessageReceiverEndpointInfo;
import de.otto.synapse.info.MessageReceiverEndpointInfos;
import de.otto.synapse.info.MessageReceiverNotification;
import de.otto.synapse.info.MessageReceiverStatus;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class MessageReceiverEndpointInfoProvider {
    private final MessageReceiverEndpointInfos messageReceiverEndpointInfos = new MessageReceiverEndpointInfos();
    private final Set<String> allChannels = new ConcurrentSkipListSet<String>();
    private final Set<String> startedChannels = new ConcurrentSkipListSet<String>();
    private final Map<String, Instant> channelStartupTimes = new ConcurrentHashMap<String, Instant>();
    private final Clock clock;

    @Autowired
    public MessageReceiverEndpointInfoProvider(Optional<List<EventSource>> eventSources) {
        this(eventSources, Clock.systemDefaultZone());
    }

    public MessageReceiverEndpointInfoProvider(Optional<List<EventSource>> eventSources, Clock clock) {
        eventSources.ifPresent(es -> es.stream().map(EventSource::getChannelName).forEach(channelName -> {
            this.allChannels.add((String)channelName);
            this.messageReceiverEndpointInfos.add(channelName);
        }));
        this.clock = clock;
    }

    @EventListener
    public void on(MessageReceiverNotification notification) {
        String channelName = notification.getChannelName();
        switch (notification.getStatus()) {
            case STARTING: {
                MessageReceiverEndpointInfo.Builder builder = MessageReceiverEndpointInfo.builder().withChannelName(notification.getChannelName()).withStatus(MessageReceiverStatus.STARTING).withMessage(notification.getMessage());
                this.messageReceiverEndpointInfos.update(channelName, builder.build());
                this.channelStartupTimes.put(channelName, this.clock.instant());
                break;
            }
            case STARTED: {
                this.messageReceiverEndpointInfos.update(channelName, MessageReceiverEndpointInfo.builder().withChannelName(channelName).withStatus(notification.getStatus()).withMessage(notification.getMessage()).build());
                break;
            }
            case RUNNING: {
                MessageReceiverEndpointInfo endpointInfo = MessageReceiverEndpointInfo.builder().withChannelName(channelName).withStatus(notification.getStatus()).withChannelDurationBehind(notification.getChannelDurationBehind().orElse(ChannelDurationBehind.unknown())).withMessage(String.format("Channel is %s behind head.", notification.getChannelDurationBehind())).build();
                this.messageReceiverEndpointInfos.update(channelName, endpointInfo);
                break;
            }
            case FINISHED: {
                Duration runtime = Duration.between(this.channelStartupTimes.get(channelName), this.clock.instant());
                ChannelDurationBehind lastDurationBehind = this.messageReceiverEndpointInfos.getChannelInfoFor(channelName).getDurationBehind().orElse(null);
                this.messageReceiverEndpointInfos.update(channelName, MessageReceiverEndpointInfo.builder().withChannelName(channelName).withStatus(notification.getStatus()).withChannelDurationBehind(lastDurationBehind).withMessage(String.format("%s Finished consumption after %s.", notification.getMessage(), runtime)).build());
                break;
            }
            case FAILED: {
                this.messageReceiverEndpointInfos.update(channelName, MessageReceiverEndpointInfo.builder().withChannelName(channelName).withStatus(notification.getStatus()).withMessage(notification.getMessage()).build());
                break;
            }
        }
    }

    public MessageReceiverEndpointInfos getInfos() {
        return this.messageReceiverEndpointInfos;
    }
}

