/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.history;

import de.otto.synapse.edison.history.History;
import de.otto.synapse.edison.history.HistoryService;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@ConditionalOnProperty(prefix="synapse.edison.history", name={"enabled"}, havingValue="true")
@Controller
public class HistoryController {
    private final HistoryService historyService;

    public HistoryController(HistoryService historyService) {
        this.historyService = historyService;
    }

    @GetMapping(value={"${management.context-path}/history/{type}/{entityId}"}, produces={"application/json"})
    public ResponseEntity<Map<String, History>> getHistoryAsJson(@PathVariable String type, @PathVariable String entityId) {
        Map<String, History> history = Collections.singletonMap("history", this.historyService.getHistory(type, entityId));
        return ResponseEntity.ok(history);
    }
}

