/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import de.otto.synapse.edison.trace.MessageTraces;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.messagestore.InMemoryRingBufferMessageStore;
import de.otto.synapse.messagestore.MessageStore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="synapse.edison.trace", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MessageTraceAutoConfiguration {
    @Autowired
    private MessageInterceptorRegistry interceptorRegistry;
    @Value(value="${synapse.edison.trace.capacity:100}")
    private int capacity = 100;

    @Bean
    @ConditionalOnMissingBean
    public MessageTraces traceMessageStore(Optional<List<MessageLogReceiverEndpoint>> messageLogReceiverEndpoints, Optional<List<MessageSenderEndpoint>> senderEndpoints) {
        return new MessageTraces(this.messageStoresFor(messageLogReceiverEndpoints.orElse(Collections.emptyList())), this.messageStoresFor(senderEndpoints.orElse(Collections.emptyList())));
    }

    private ImmutableMap<String, MessageStore> messageStoresFor(List<? extends MessageEndpoint> messageEndpoints) {
        ImmutableBiMap.Builder senderStores = ImmutableBiMap.builder();
        messageEndpoints.forEach(arg_0 -> this.lambda$messageStoresFor$1((ImmutableMap.Builder)senderStores, arg_0));
        return senderStores.build();
    }

    private /* synthetic */ void lambda$messageStoresFor$1(ImmutableMap.Builder senderStores, MessageEndpoint senderEndpoint) {
        InMemoryRingBufferMessageStore messageStore = new InMemoryRingBufferMessageStore(this.capacity);
        senderEndpoint.getInterceptorChain().register(message -> {
            messageStore.add(message);
            return message;
        });
        senderStores.put((Object)senderEndpoint.getChannelName(), (Object)messageStore);
    }
}

