/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.edison.navigation.NavBar;
import de.otto.edison.navigation.NavBarItem;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.edison.trace.MessageTraces;
import de.otto.synapse.message.Header;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ConditionalOnBean(name={"traceMessageStore"})
public class MessageTraceController {
    private final MessageTraces messageTraces;
    private final ObjectMapper objectMapper;

    @Autowired
    MessageTraceController(MessageTraces messageTraces, NavBar rightNavBar, ManagementServerProperties managementServerProperties, ObjectMapper objectMapper) {
        this.messageTraces = messageTraces;
        this.objectMapper = objectMapper;
        messageTraces.getSenderChannels().forEach(channelName -> rightNavBar.register(NavBarItem.navBarItem((int)10, (String)("Sender: " + channelName), (String)String.format("%s/messagetrace/sender/%s", managementServerProperties.getContextPath(), channelName))));
        messageTraces.getReceiverChannels().forEach(channelName -> rightNavBar.register(NavBarItem.navBarItem((int)20, (String)("Receiver: " + channelName), (String)String.format("%s/messagetrace/receiver/%s", managementServerProperties.getContextPath(), channelName))));
    }

    @GetMapping(path={"${management.context-path}/messagetrace/{endpointType}/{channelName}"}, produces={"text/html"})
    public ModelAndView getMessageTrace(@PathVariable String endpointType, @PathVariable String channelName) {
        return new ModelAndView("messagetrace", (Map)ImmutableMap.of((Object)"title", (Object)(endpointType.equals("receiver") ? "Receiver: " : "Sender: " + channelName), (Object)"channelName", (Object)channelName, (Object)"messages", this.messageTraces.getReceiverTrace(channelName).stream().map(message -> ImmutableMap.of((Object)"key", (Object)message.getKey(), (Object)"header", (Object)this.prettyPrint(message.getHeader()), (Object)"payload", (Object)this.prettyPrint((String)message.getPayload()))).collect(Collectors.toList())));
    }

    private String prettyPrint(String json) {
        try {
            Object jsonObject = this.objectMapper.readValue(json, Object.class);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String prettyPrint(Header header) {
        try {
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put("shardPosition", header.getShardPosition().map(ShardPosition::toString).orElse(""));
            map.put("arrivalTimestamp", header.getArrivalTimestamp().toString());
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

