/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.Iterables;
import de.otto.synapse.edison.trace.MessageTrace;
import de.otto.synapse.endpoint.receiver.MessageReceiverEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="synapse.edison.trace", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MessageTraceAutoConfiguration {
    @Value(value="${synapse.edison.trace.capacity:500}")
    private int capacity = 500;

    @Bean
    @ConditionalOnMissingBean
    public MessageTrace messageTrace(Optional<List<MessageReceiverEndpoint>> messageReceiverEndpoints, Optional<List<MessageSenderEndpoint>> senderEndpoints) {
        return new MessageTrace(this.capacity, Iterables.concat((Iterable)messageReceiverEndpoints.orElse(Collections.emptyList()), (Iterable)senderEndpoints.orElse(Collections.emptyList())));
    }
}

