/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.kafka;

import de.otto.synapse.channel.selector.Kafka;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.kafka.KafkaMessageSender;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.MessageTranslator;
import de.otto.synapse.translator.TextMessageTranslator;
import javax.annotation.Nonnull;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaMessageSenderEndpointFactory
implements MessageSenderEndpointFactory {
    private final MessageInterceptorRegistry registry;
    private final KafkaTemplate<String, String> kafkaTemplate;

    public KafkaMessageSenderEndpointFactory(MessageInterceptorRegistry registry, KafkaTemplate<String, String> kafkaTemplate) {
        this.registry = registry;
        this.kafkaTemplate = kafkaTemplate;
    }

    public MessageSenderEndpoint create(@Nonnull String channelName, MessageFormat messageFormat) {
        return new KafkaMessageSender(channelName, this.registry, (MessageTranslator<TextMessage>)new TextMessageTranslator(), this.kafkaTemplate);
    }

    public boolean matches(Class<? extends Selector> channelSelector) {
        return channelSelector.isAssignableFrom(this.selector());
    }

    public Class<? extends Selector> selector() {
        return Kafka.class;
    }
}

