/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.kafka;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public class ConsumerRebalanceListeners
implements ConsumerRebalanceListener {
    private final List<ConsumerRebalanceListener> listeners;

    private ConsumerRebalanceListeners(ConsumerRebalanceListener ... listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    static ConsumerRebalanceListeners of(ConsumerRebalanceListener ... listeners) {
        return new ConsumerRebalanceListeners(listeners);
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        this.listeners.forEach(listener -> listener.onPartitionsAssigned(partitions));
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        this.listeners.forEach(listener -> listener.onPartitionsRevoked(partitions));
    }

    public void onPartitionsLost(Collection<TopicPartition> partitions) {
        this.listeners.forEach(listener -> listener.onPartitionsLost(partitions));
    }
}

