/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.kafka;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.message.Key;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.Encoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.utils.Utils;

public class KafkaEncoder
implements Encoder<ProducerRecord<String, String>> {
    public static String COMPACTION_KEY = "_synapse_msg_compactionKey";
    public static String PARTITION_KEY = "_synapse_msg_partitionKey";
    private final String channelName;
    private final int numPartitions;

    public KafkaEncoder(String channelName, int numPartitions) {
        this.channelName = channelName;
        this.numPartitions = numPartitions;
    }

    public ProducerRecord<String, String> apply(Message<String> message) {
        Key key = message.getKey();
        Integer partition = key.isCompoundKey() ? Integer.valueOf(this.kafkaPartitionFrom(key.partitionKey())) : null;
        return new ProducerRecord(this.channelName, partition, (Object)key.compactionKey(), message.getPayload(), this.headersOf(message));
    }

    private List<Header> headersOf(Message<String> message) {
        ImmutableList.Builder messageAttributes = ImmutableList.builder();
        message.getHeader().getAll().forEach((key, value) -> messageAttributes.add((Object)new RecordHeader(key, value.getBytes(StandardCharsets.UTF_8))));
        messageAttributes.add((Object[])new Header[]{new RecordHeader(PARTITION_KEY, message.getKey().partitionKey().getBytes(StandardCharsets.UTF_8)), new RecordHeader(COMPACTION_KEY, message.getKey().compactionKey().getBytes(StandardCharsets.UTF_8))});
        return messageAttributes.build();
    }

    private int kafkaPartitionFrom(String partitionKey) {
        return Utils.toPositive((int)Utils.murmur2((byte[])partitionKey.getBytes())) % this.numPartitions;
    }
}

