/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.kafka;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.otto.synapse.channel.selector.Kafka;
import de.otto.synapse.configuration.EventSourcingAutoConfiguration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.kafka.KafkaMessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.kafka.KafkaMessageSenderEndpointFactory;
import de.otto.synapse.eventsource.DefaultEventSourceBuilder;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.MessageStores;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@Import(value={EventSourcingAutoConfiguration.class, KafkaAutoConfiguration.class})
@EnableScheduling
@EnableKafka
@EnableConfigurationProperties(value={KafkaProperties.class})
public class SynapseKafkaAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SynapseKafkaAutoConfiguration.class);

    @Bean
    public EventSourceBuilder kafkaEventSourceBuilder() {
        return new DefaultEventSourceBuilder(_x -> MessageStores.emptyMessageStore(), Kafka.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageStoreFactory<? extends MessageStore> messageStoreFactory() {
        return _x -> MessageStores.emptyMessageStore();
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaMessageLogSenderEndpointFactory"})
    public MessageSenderEndpointFactory kafkaMessageLogSenderEndpointFactory(MessageInterceptorRegistry registry, KafkaTemplate<String, String> kafkaTemplate) {
        LOG.info("Auto-configuring Kafka MessageSenderEndpointFactory");
        return new KafkaMessageSenderEndpointFactory(registry, kafkaTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaMessageLogReceiverEndpointFactory"})
    public MessageLogReceiverEndpointFactory kafkaMessageLogReceiverEndpointFactory(KafkaProperties kafkaProperties, MessageInterceptorRegistry interceptorRegistry, ApplicationEventPublisher eventPublisher, ConsumerFactory<String, String> kafkaConsumerFactory) {
        LOG.info("Auto-configuring Kafka MessageLogReceiverEndpointFactory");
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("kafka-message-log-%d").build());
        KafkaConsumer kafkaConsumer = (KafkaConsumer)kafkaConsumerFactory.createConsumer();
        return new KafkaMessageLogReceiverEndpointFactory(interceptorRegistry, (KafkaConsumer<String, String>)kafkaConsumer, executorService, eventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaConsumerFactory"})
    public ConsumerFactory<String, String> kafkaConsumerFactory(KafkaProperties kafkaProperties) {
        return new DefaultKafkaConsumerFactory(kafkaProperties.buildConsumerProperties(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }
}

