/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.kafka;

import de.otto.synapse.channel.selector.Kafka;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.kafka.KafkaMessageLogReceiverEndpoint;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.springframework.context.ApplicationEventPublisher;

public class KafkaMessageLogReceiverEndpointFactory
implements MessageLogReceiverEndpointFactory {
    private final MessageInterceptorRegistry interceptorRegistry;
    private final KafkaConsumer<String, String> kafkaConsumer;
    private final ApplicationEventPublisher eventPublisher;
    private final ExecutorService executorService;

    public KafkaMessageLogReceiverEndpointFactory(MessageInterceptorRegistry interceptorRegistry, KafkaConsumer<String, String> kafkaConsumer, ExecutorService kinesisMessageLogExecutorService, ApplicationEventPublisher eventPublisher) {
        this.interceptorRegistry = interceptorRegistry;
        this.kafkaConsumer = kafkaConsumer;
        this.executorService = kinesisMessageLogExecutorService;
        this.eventPublisher = eventPublisher;
    }

    public MessageLogReceiverEndpoint create(@Nonnull String channelName) {
        return new KafkaMessageLogReceiverEndpoint(channelName, this.interceptorRegistry, this.kafkaConsumer, this.executorService, this.eventPublisher);
    }

    public boolean matches(Class<? extends Selector> channelSelector) {
        return channelSelector.isAssignableFrom(this.selector());
    }

    public Class<? extends Selector> selector() {
        return Kafka.class;
    }
}

