/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.kafka;

import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Key;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.Decoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDecoder
implements Decoder<ConsumerRecord<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDecoder.class);
    public static String COMPACTION_KEY = "_synapse_msg_compactionKey";
    public static String PARTITION_KEY = "_synapse_msg_partitionKey";

    public TextMessage apply(ConsumerRecord<String, String> record) {
        return TextMessage.of((Key)this.toKey(record), (Header)this.toHeader(record), (String)((String)record.value()));
    }

    private Key toKey(ConsumerRecord<String, String> record) {
        Headers headers = record.headers();
        String partitionKey = this.lastHeader(headers, PARTITION_KEY);
        String compactionKey = this.lastHeader(headers, COMPACTION_KEY);
        Key key = partitionKey != null && compactionKey != null && compactionKey.equals(record.key()) ? Key.of((String)partitionKey, (String)compactionKey) : (record.key() == null ? Key.of((String)UUID.randomUUID().toString()) : Key.of((String)((String)record.key())));
        return key;
    }

    private Header toHeader(ConsumerRecord<String, String> record) {
        Header.Builder builder = Header.builder().withShardPosition(ShardPosition.fromPosition((String)("" + record.partition()), (String)("" + record.offset())));
        record.headers().forEach(header -> builder.withAttribute(header.key(), this.toString(header.value())));
        return builder.build();
    }

    private String lastHeader(Headers headers, String key) {
        org.apache.kafka.common.header.Header header = headers.lastHeader(key);
        return header != null ? this.toString(header.value()) : null;
    }

    private String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

