/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore.redis;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.WritableMessageStore;
import de.otto.synapse.messagestore.redis.BatchedRedisListIterator;
import de.otto.synapse.translator.MessageCodec;
import de.otto.synapse.translator.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;

public class RedisMessageStore
implements WritableMessageStore {
    private static final int CHARACTERISTICS = 1296;
    private final String channelName;
    private final RedisTemplate<String, String> redisTemplate;
    private final int batchSize;
    private final int maxSize;

    public RedisMessageStore(String channelName, RedisTemplate<String, String> stringRedisTemplate, int batchSize, int maxSize) {
        this.channelName = channelName;
        this.redisTemplate = stringRedisTemplate;
        this.batchSize = batchSize;
        this.maxSize = maxSize;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void add(final Message<String> message) {
        List txResults = (List)this.redisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                message.getHeader().getShardPosition().ifPresent(shardPosition -> operations.boundHashOps((Object)(RedisMessageStore.this.channelName + "-channelPos")).put((Object)shardPosition.shardName(), (Object)shardPosition.position()));
                operations.boundListOps((Object)(RedisMessageStore.this.channelName + "-messages")).rightPush((Object)RedisMessageStore.toRedisValue((Message<String>)message));
                operations.boundListOps((Object)(RedisMessageStore.this.channelName + "-messages")).trim((long)(-RedisMessageStore.this.maxSize), -1L);
                return operations.exec();
            }
        });
    }

    public ChannelPosition getLatestChannelPosition() {
        Set shardPositions = this.redisTemplate.boundHashOps((Object)(this.channelName + "-channelPos")).entries().entrySet().stream().map(entry -> ShardPosition.fromPosition((String)entry.getKey().toString(), (String)entry.getValue().toString())).collect(Collectors.toSet());
        return ChannelPosition.channelPosition(shardPositions);
    }

    public Stream<Message<String>> stream() {
        BatchedRedisListIterator<Message, String> messageIterator = new BatchedRedisListIterator<Message, String>(this.redisTemplate, RedisMessageStore::messageOf, this.channelName + "-messages", this.batchSize);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(messageIterator, 1296), false);
    }

    public int size() {
        return this.redisTemplate.boundListOps((Object)(this.channelName + "-messages")).size().intValue();
    }

    public void close() {
    }

    static Message<String> messageOf(String redisValue) {
        return MessageCodec.decode((String)redisValue, (Header.Builder)Header.builder(), (Message.Builder)Message.builder(String.class));
    }

    static String toRedisValue(Message<String> message) {
        return MessageCodec.encode(message, (MessageFormat)MessageFormat.V2);
    }

    public void clear() {
        this.redisTemplate.delete(Arrays.asList(this.channelName + "-channelPos", this.channelName + "-messages"));
    }
}

