/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore.redis;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import de.otto.synapse.messagestore.redis.BatchedRedisListIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;

@Beta
class BatchedRedisHashedListIterator<R>
implements Iterator<R> {
    private final RedisTemplate<String, String> redisTemplate;
    private final String redisListName;
    private final Function<Map<String, String>, R> valueTransformer;
    private final BatchedRedisListIterator<String, String> messageListIterator;
    private R next;

    BatchedRedisHashedListIterator(RedisTemplate<String, String> redisTemplate, Function<Map<String, String>, R> valueTransformer, String redisListName, int batchSize) {
        this.valueTransformer = valueTransformer;
        Objects.requireNonNull(redisTemplate, "Parameter redisTemplate must not be null");
        if (batchSize < 1) {
            throw new IllegalArgumentException("Parameter batchSize must be greater 0");
        }
        if (Strings.isNullOrEmpty((String)redisListName)) {
            throw new IllegalArgumentException("Parameter redisListName must not be empty");
        }
        this.redisTemplate = redisTemplate;
        this.redisListName = redisListName;
        this.messageListIterator = new BatchedRedisListIterator(redisTemplate, Function.identity(), redisListName, batchSize);
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        String messageHashKey;
        BoundHashOperations hashOps;
        Map entries;
        if (this.next == null && this.messageListIterator.hasNext() && (entries = (hashOps = this.redisTemplate.boundHashOps((Object)(messageHashKey = this.messageListIterator.next()))).entries()) != null && !entries.isEmpty()) {
            this.next = this.valueTransformer.apply(entries);
        }
        return this.next != null;
    }

    @Override
    public R next() {
        if (this.hasNext()) {
            R element = this.next;
            this.next = null;
            return element;
        }
        throw new NoSuchElementException("No more messages available in " + this.redisListName);
    }
}

