/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import de.otto.synapse.messagestore.redis.BatchedRedisListIterator;
import de.otto.synapse.translator.Decoder;
import de.otto.synapse.translator.Encoder;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.ObjectMappers;
import de.otto.synapse.translator.TextDecoder;
import de.otto.synapse.translator.TextEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;

@Beta
public class RedisRingBufferMessageStore
implements MessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(RedisRingBufferMessageStore.class);
    private static final int CHARACTERISTICS = 1296;
    private final String name;
    private final RedisTemplate<String, String> redisTemplate;
    private final int batchSize;
    private final int maxSize;
    private final Encoder<String> encoder;
    private final Decoder<String> decoder;

    public RedisRingBufferMessageStore(String name, int batchSize, int ringBufferSize, RedisTemplate<String, String> stringRedisTemplate) {
        this(name, batchSize, ringBufferSize, stringRedisTemplate, (Encoder<String>)new TextEncoder(MessageFormat.V2), (Decoder<String>)new TextDecoder());
    }

    public RedisRingBufferMessageStore(String name, int batchSize, int ringBufferSize, RedisTemplate<String, String> stringRedisTemplate, Encoder<String> messageEncoder, Decoder<String> messageDecoder) {
        this.name = name;
        this.redisTemplate = stringRedisTemplate;
        this.batchSize = batchSize;
        this.maxSize = ringBufferSize;
        this.encoder = messageEncoder;
        this.decoder = messageDecoder;
    }

    public void add(final MessageStoreEntry entry) {
        List txResults = (List)this.redisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                entry.getTextMessage().getHeader().getShardPosition().ifPresent(shardPosition -> {
                    String channelPosHashKey = RedisRingBufferMessageStore.this.name + "-" + entry.getChannelName() + "-channelPos";
                    BoundHashOperations channelPosHash = operations.boundHashOps((Object)channelPosHashKey);
                    channelPosHash.put((Object)shardPosition.shardName(), (Object)shardPosition.position());
                });
                String channelNamesSetKey = RedisRingBufferMessageStore.this.name + "-channels";
                BoundSetOperations channelNamesSet = operations.boundSetOps((Object)channelNamesSetKey);
                channelNamesSet.add(new Object[]{entry.getChannelName()});
                String messagesListKey = RedisRingBufferMessageStore.this.name + "-messages";
                BoundListOperations messagesList = operations.boundListOps((Object)messagesListKey);
                messagesList.rightPush((Object)RedisRingBufferMessageStore.this.encode(entry));
                messagesList.trim((long)(-RedisRingBufferMessageStore.this.maxSize), -1L);
                return operations.exec();
            }
        });
        LOG.debug("Redis returned with " + txResults);
    }

    public Set<String> getChannelNames() {
        Set members = this.redisTemplate.boundSetOps((Object)(this.name + "-channels")).members();
        return members;
    }

    public ImmutableSet<Index> getIndexes() {
        return ImmutableSet.of();
    }

    public ChannelPosition getLatestChannelPosition(String channelName) {
        Set shardPositions = this.redisTemplate.boundHashOps((Object)(this.name + "-" + channelName + "-channelPos")).entries().entrySet().stream().map(entry -> ShardPosition.fromPosition((String)entry.getKey().toString(), (String)entry.getValue().toString())).collect(Collectors.toSet());
        return ChannelPosition.channelPosition(shardPositions);
    }

    public Stream<MessageStoreEntry> stream() {
        BatchedRedisListIterator<MessageStoreEntry, String> messageIterator = new BatchedRedisListIterator<MessageStoreEntry, String>(this.redisTemplate, this::decode, this.name + "-messages", this.batchSize);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(messageIterator, 1296), false);
    }

    public Stream<MessageStoreEntry> stream(Index index, String value) {
        throw new UnsupportedOperationException();
    }

    public long size() {
        return this.redisTemplate.boundListOps((Object)(this.name + "-messages")).size();
    }

    public void close() {
    }

    public void clear() {
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.name + "-channels", this.name + "-messages"));
        this.getChannelNames().forEach(channel -> keys.add(this.name + "-" + channel + "-channelPos"));
        this.redisTemplate.delete(keys);
    }

    private String encode(MessageStoreEntry entry) {
        try {
            return ObjectMappers.currentObjectMapper().writeValueAsString((Object)ImmutableMap.of((Object)"channelName", (Object)entry.getChannelName(), (Object)"message", (Object)this.encoder.apply((Object)entry.getTextMessage())));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to encode MessageStoreEntry " + entry + ": " + e.getMessage(), e);
        }
    }

    private MessageStoreEntry decode(String value) {
        try {
            Map map = (Map)ObjectMappers.currentObjectMapper().readValue(value, Map.class);
            return MessageStoreEntry.of((String)map.get("channelName").toString(), (TextMessage)((TextMessage)this.decoder.apply((Object)map.get("message").toString())));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decode MessageStoreEntry from " + value + ": " + e.getMessage(), e);
        }
    }
}

