/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.leaderelection.redis;

import com.google.common.annotations.Beta;
import de.otto.synapse.leaderelection.LeaderElection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class RedisLeaderElection
implements LeaderElection {
    private static final Logger LOG = LoggerFactory.getLogger(RedisLeaderElection.class);
    private final RedissonClient redissonClient;

    public RedisLeaderElection(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public final CompletableFuture<Void> runAsyncIfLeader(String lockName, Runnable runnable) {
        return CompletableFuture.runAsync(() -> this.runIfLeader(lockName, runnable));
    }

    public final CompletableFuture<Void> runAsyncIfLeader(String lockName, Runnable runnable, Executor executor) {
        return CompletableFuture.runAsync(() -> this.runIfLeader(lockName, runnable), executor);
    }

    public final <T> CompletableFuture<T> supplyAsyncIfLeader(String lockName, Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> this.supplyIfLeader(lockName, supplier));
    }

    public final <T> CompletableFuture<T> supplyAsyncIfLeader(String lockName, Supplier<T> supplier, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.supplyIfLeader(lockName, supplier), executor);
    }

    public final void runIfLeader(String lockName, Runnable runnable) {
        this.supplyIfLeader(lockName, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T supplyIfLeader(String lockName, Supplier<T> supplier) {
        T result;
        block6: {
            RLock lock = this.redissonClient.getLock(lockName);
            result = null;
            try {
                LOG.info("Waiting for becoming leader...");
                if (!lock.tryLock(5L, TimeUnit.SECONDS)) break block6;
                LOG.info("Thread {} is leader for {} ", (Object)Thread.currentThread().getName(), (Object)lock.getName());
                try {
                    result = supplier.get();
                }
                finally {
                    if (lock.isHeldByCurrentThread()) {
                        lock.unlock();
                        LOG.info("Released leader-election lock {}", (Object)Thread.currentThread().getName(), (Object)lock.getName());
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

