/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore.redis;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.data.redis.core.RedisTemplate;

class BatchedRedisListIterator<R, T>
implements Iterator<R> {
    private final RedisTemplate<String, T> redisTemplate;
    private final String redisListName;
    private final Function<T, R> valueTransformer;
    private Iterator<T> currentBatchIterator;
    private final int batchSize;
    private int currentBatchPos;
    private int nextBatch;

    BatchedRedisListIterator(RedisTemplate<String, T> redisTemplate, Function<T, R> valueTransformer, String redisListName, int batchSize) {
        this.valueTransformer = valueTransformer;
        Objects.requireNonNull(redisTemplate, "Parameter redisTemplate must not be null");
        if (batchSize < 1) {
            throw new IllegalArgumentException("Parameter batchSize must be greater 0");
        }
        if (Strings.isNullOrEmpty((String)redisListName)) {
            throw new IllegalArgumentException("Parameter redisListName must not be empty");
        }
        this.redisTemplate = redisTemplate;
        this.redisListName = redisListName;
        this.currentBatchIterator = redisTemplate.boundListOps((Object)this.redisListName).range(0L, (long)(batchSize - 1)).iterator();
        this.currentBatchPos = 0;
        this.batchSize = batchSize;
        this.nextBatch = 1;
    }

    @Override
    public boolean hasNext() {
        if (!this.currentBatchIterator.hasNext() && this.currentBatchPos == this.batchSize) {
            int start = this.batchSize * this.nextBatch;
            int end = this.batchSize * this.nextBatch + this.batchSize - 1;
            this.currentBatchIterator = this.redisTemplate.boundListOps((Object)this.redisListName).range((long)start, (long)end).iterator();
            this.currentBatchPos = 0;
            ++this.nextBatch;
        }
        return this.currentBatchIterator.hasNext();
    }

    @Override
    public R next() {
        if (this.hasNext()) {
            ++this.currentBatchPos;
            return this.valueTransformer.apply(this.currentBatchIterator.next());
        }
        throw new NoSuchElementException("No more messages available in " + this.redisListName);
    }
}

