/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.configuration.InMemoryChannelTestConfiguration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.InMemoryMessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.InMemoryMessageSenderFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.messagestore.CompactingInMemoryMessageStore;
import de.otto.synapse.messagestore.DelegatingSnapshotMessageStore;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@ImportAutoConfiguration(value={InMemoryChannelTestConfiguration.class})
public class InMemoryMessageLogTestConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageLogTestConfiguration.class);

    @Bean
    public MessageSenderEndpointFactory messageLogSenderEndpointFactory(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels, ObjectMapper objectMapper) {
        LOG.warn("Creating InMemoryMessageSenderEndpointFactory. This should only be used in tests");
        return new InMemoryMessageSenderFactory(interceptorRegistry, inMemoryChannels, objectMapper);
    }

    @Bean
    public MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory() {
        return channelName -> new DelegatingSnapshotMessageStore((MessageStore)new CompactingInMemoryMessageStore(true));
    }

    @Bean
    public MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory(InMemoryChannels inMemoryChannels) {
        LOG.warn("Creating InMemoryMessageLogReceiverEndpointFactory. This should only be used in tests");
        return new InMemoryMessageLogReceiverEndpointFactory(inMemoryChannels);
    }
}

