/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.channel.selector.MessageQueue;
import de.otto.synapse.configuration.InMemoryChannelTestConfiguration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.InMemoryMessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.InMemoryMessageSenderFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={InMemoryChannelTestConfiguration.class})
public class InMemoryMessageQueueTestConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageQueueTestConfiguration.class);

    @Bean
    public MessageSenderEndpointFactory messageQueueSenderEndpointFactory(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels) {
        LOG.warn("Creating InMemoryMessageSenderEndpointFactory. This should only be used in tests");
        return new InMemoryMessageSenderFactory(interceptorRegistry, inMemoryChannels, MessageQueue.class);
    }

    @Bean
    public MessageQueueReceiverEndpointFactory messageQueueReceiverEndpointFactory(InMemoryChannels inMemoryChannels) {
        LOG.warn("Creating InMemoryMessageLogReceiverEndpointFactory. This should only be used in tests");
        return new InMemoryMessageQueueReceiverEndpointFactory(inMemoryChannels);
    }
}

