/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.channel.selector.MessageLog;
import de.otto.synapse.configuration.InMemoryChannelTestConfiguration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.InMemoryMessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.InMemoryMessageSenderFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.messagestore.DelegatingSnapshotMessageStore;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.OnHeapCompactingMessageStore;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={InMemoryChannelTestConfiguration.class})
public class InMemoryMessageLogTestConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageLogTestConfiguration.class);

    @Bean
    public MessageSenderEndpointFactory messageLogSenderEndpointFactory(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels) {
        LOG.warn("Creating InMemoryMessageSenderEndpointFactory. This should only be used in tests");
        return new InMemoryMessageSenderFactory(interceptorRegistry, inMemoryChannels, MessageLog.class);
    }

    @Bean
    public MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory() {
        return channelName -> new DelegatingSnapshotMessageStore((MessageStore)new OnHeapCompactingMessageStore(true));
    }

    @Bean
    public MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory(InMemoryChannels inMemoryChannels) {
        LOG.warn("Creating InMemoryMessageLogReceiverEndpointFactory. This should only be used in tests");
        return new InMemoryMessageLogReceiverEndpointFactory(inMemoryChannels);
    }
}

