/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.InMemoryMessageSender;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.MessageTranslator;
import de.otto.synapse.translator.TextMessageTranslator;
import javax.annotation.Nonnull;

public class InMemoryMessageSenderFactory
implements MessageSenderEndpointFactory {
    private final MessageInterceptorRegistry registry;
    private final InMemoryChannels inMemoryChannels;
    private final Class<? extends Selector> selector;

    public InMemoryMessageSenderFactory(MessageInterceptorRegistry registry, InMemoryChannels inMemoryChannels, Class<? extends Selector> selector) {
        this.registry = registry;
        this.inMemoryChannels = inMemoryChannels;
        this.selector = selector;
    }

    public InMemoryMessageSender create(@Nonnull String channelName, MessageFormat messageFormat) {
        InMemoryMessageSender messageSender = new InMemoryMessageSender(this.registry, (MessageTranslator<TextMessage>)new TextMessageTranslator(), this.inMemoryChannels.getChannel(channelName));
        return messageSender;
    }

    public boolean matches(Class<? extends Selector> channelSelector) {
        return this.selector == null || this.selector.isAssignableFrom(channelSelector);
    }

    public Class<? extends Selector> selector() {
        return this.selector;
    }
}

