/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.api;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Byte;
import de.pauleff.core.Tag_Byte_Array;
import de.pauleff.core.Tag_Compound;
import de.pauleff.core.Tag_Double;
import de.pauleff.core.Tag_Float;
import de.pauleff.core.Tag_Int;
import de.pauleff.core.Tag_Int_Array;
import de.pauleff.core.Tag_List;
import de.pauleff.core.Tag_Long;
import de.pauleff.core.Tag_Long_Array;
import de.pauleff.core.Tag_Short;
import de.pauleff.core.Tag_String;
import de.pauleff.formats.snbt.SNBTException;
import de.pauleff.formats.snbt.SNBTParser;
import de.pauleff.formats.snbt.SNBTSerializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class NBTFactory {
    public static ICompoundTag createCompound() {
        return new Tag_Compound();
    }

    public static ICompoundTag createCompound(String name) {
        return new Tag_Compound(name);
    }

    public static ICompoundTag createCompound(String name, ArrayList<ITag<?>> data) {
        ArrayList tagData = new ArrayList();
        for (ITag<?> tag : data) {
            tagData.add((Tag)tag);
        }
        return new Tag_Compound(name, tagData);
    }

    public static IListTag createList(int listTypeID) {
        return new Tag_List(listTypeID);
    }

    public static IListTag createList(String name, int listTypeID) {
        return new Tag_List(name, listTypeID);
    }

    public static ITag<String> createString() {
        return new Tag_String();
    }

    public static ITag<String> createString(String name) {
        return new Tag_String(name);
    }

    public static ITag<String> createString(String name, String value) {
        return new Tag_String(name, value);
    }

    public static ITag<Integer> createInt() {
        return new Tag_Int();
    }

    public static ITag<Integer> createInt(String name) {
        return new Tag_Int(name);
    }

    public static ITag<Integer> createInt(String name, int value) {
        return new Tag_Int(name, value);
    }

    public static ITag<Double> createDouble() {
        return new Tag_Double();
    }

    public static ITag<Double> createDouble(String name) {
        return new Tag_Double(name);
    }

    public static ITag<Double> createDouble(String name, double value) {
        return new Tag_Double(name, value);
    }

    public static ITag<Float> createFloat() {
        return new Tag_Float();
    }

    public static ITag<Float> createFloat(String name) {
        return new Tag_Float(name);
    }

    public static ITag<Float> createFloat(String name, float value) {
        return new Tag_Float(name, value);
    }

    public static ITag<Byte> createByte() {
        return new Tag_Byte();
    }

    public static ITag<Byte> createByte(String name) {
        return new Tag_Byte(name);
    }

    public static ITag<Byte> createByte(String name, byte value) {
        return new Tag_Byte(name, value);
    }

    public static ITag<Short> createShort() {
        return new Tag_Short();
    }

    public static ITag<Short> createShort(String name) {
        return new Tag_Short(name);
    }

    public static ITag<Short> createShort(String name, short value) {
        return new Tag_Short(name, value);
    }

    public static ITag<Long> createLong() {
        return new Tag_Long();
    }

    public static ITag<Long> createLong(String name) {
        return new Tag_Long(name);
    }

    public static ITag<Long> createLong(String name, long value) {
        return new Tag_Long(name, value);
    }

    public static ITag<byte[]> createByteArray() {
        return new Tag_Byte_Array();
    }

    public static ITag<byte[]> createByteArray(String name) {
        return new Tag_Byte_Array(name);
    }

    public static ITag<byte[]> createByteArray(String name, byte[] value) {
        return new Tag_Byte_Array(name, value);
    }

    public static ITag<int[]> createIntArray() {
        return new Tag_Int_Array();
    }

    public static ITag<int[]> createIntArray(String name) {
        return new Tag_Int_Array(name);
    }

    public static ITag<int[]> createIntArray(String name, int[] value) {
        return new Tag_Int_Array(name, value);
    }

    public static ITag<long[]> createLongArray() {
        return new Tag_Long_Array();
    }

    public static ITag<long[]> createLongArray(String name) {
        return new Tag_Long_Array(name);
    }

    public static ITag<long[]> createLongArray(String name, long[] value) {
        return new Tag_Long_Array(name, value);
    }

    public static ICompoundTag createSimpleCompound(String rootName, String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide an even number of arguments (key-value pairs)");
        }
        ICompoundTag compound = NBTFactory.createCompound(rootName);
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            compound.addString(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return compound;
    }

    public static ITag<?> parseFromSNBT(String snbt) throws SNBTException {
        if (snbt == null || snbt.trim().isEmpty()) {
            throw new SNBTException("SNBT string cannot be null or empty");
        }
        SNBTParser parser = new SNBTParser(snbt.trim());
        return parser.parse();
    }

    public static ICompoundTag parseCompoundFromSNBT(String snbt) throws SNBTException {
        ITag<?> tag = NBTFactory.parseFromSNBT(snbt);
        if (!(tag instanceof ICompoundTag)) {
            throw new SNBTException("SNBT does not represent a compound tag");
        }
        return (ICompoundTag)tag;
    }

    public static IListTag parseListFromSNBT(String snbt) throws SNBTException {
        ITag<?> tag = NBTFactory.parseFromSNBT(snbt);
        if (!(tag instanceof IListTag)) {
            throw new SNBTException("SNBT does not represent a list tag");
        }
        return (IListTag)tag;
    }

    public static String toSNBT(ITag<?> tag) {
        SNBTSerializer serializer = new SNBTSerializer();
        return serializer.serialize(tag);
    }

    public static void writeToSNBTFile(ITag<?> tag, File file) throws IOException {
        SNBTSerializer serializer = new SNBTSerializer();
        serializer.writeToFile(tag, file);
    }
}

