/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.api;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.INBTReader;
import de.pauleff.api.INBTWriter;
import de.pauleff.formats.binary.Compression_Types;
import de.pauleff.formats.binary.NBTFileHandler;
import de.pauleff.formats.binary.NBTReader;
import de.pauleff.formats.binary.NBTWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class NBTFileFactory {
    public static INBTReader createReader(File nbtFile) {
        return new NBTReader(nbtFile);
    }

    public static INBTReader createReader(DataInputStream dis) {
        return new NBTReader(dis);
    }

    public static INBTWriter createWriter(File nbtFile) throws FileNotFoundException {
        return new NBTWriter(nbtFile);
    }

    public static INBTWriter createWriter(File nbtFile, Compression_Types compression) {
        return new NBTWriter(nbtFile, compression);
    }

    public static ICompoundTag readNBTFile(File nbtFile) throws IOException {
        try (INBTReader reader = NBTFileFactory.createReader(nbtFile);){
            ICompoundTag iCompoundTag = reader.read();
            return iCompoundTag;
        }
    }

    public static void writeNBTFile(File nbtFile, ICompoundTag root) throws IOException {
        try (INBTWriter writer = NBTFileFactory.createWriter(nbtFile);){
            writer.write(root);
        }
        catch (FileNotFoundException e) {
            System.out.println("NBT File could not be found, creating new one and using default compression (NONE).");
            try (INBTWriter writer2 = NBTFileFactory.createWriter(nbtFile, Compression_Types.NONE);){
                writer2.write(root);
            }
        }
    }

    public static void writeNBTFile(File nbtFile, ICompoundTag root, Compression_Types compression) throws IOException {
        try (INBTWriter writer = NBTFileFactory.createWriter(nbtFile, compression);){
            writer.write(root);
        }
    }

    public static void copyNBTFile(File source, File destination) throws IOException {
        ICompoundTag data = NBTFileFactory.readNBTFile(source);
        Compression_Types compression = NBTFileHandler.getCompressionType(source);
        NBTFileFactory.writeNBTFile(destination, data, compression);
    }

    public static boolean isValidNBTFile(File nbtFile) {
        try {
            NBTFileFactory.readNBTFile(nbtFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

