/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.builder;

import de.pauleff.api.ICompoundTag;
import de.pauleff.builder.ListBuilder;
import de.pauleff.builder.NBTBuilder;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Compound;
import de.pauleff.util.NBTTags;

public class CompoundBuilder
extends NBTBuilder {
    private final Tag_Compound compound;

    public CompoundBuilder(String name, NBTBuilder parent) {
        super(name, parent);
        CompoundBuilder.validateName(name);
        this.compound = new Tag_Compound(name);
    }

    public CompoundBuilder addString(String name, String value) {
        CompoundBuilder.validateName(name);
        this.compound.addString(name, value);
        return this;
    }

    public CompoundBuilder addInt(String name, int value) {
        CompoundBuilder.validateName(name);
        this.compound.addInt(name, value);
        return this;
    }

    public CompoundBuilder addDouble(String name, double value) {
        CompoundBuilder.validateName(name);
        this.compound.addDouble(name, value);
        return this;
    }

    public CompoundBuilder addFloat(String name, float value) {
        CompoundBuilder.validateName(name);
        this.compound.addFloat(name, value);
        return this;
    }

    public CompoundBuilder addByte(String name, byte value) {
        CompoundBuilder.validateName(name);
        this.compound.addByte(name, value);
        return this;
    }

    public CompoundBuilder addShort(String name, short value) {
        CompoundBuilder.validateName(name);
        this.compound.addShort(name, value);
        return this;
    }

    public CompoundBuilder addLong(String name, long value) {
        CompoundBuilder.validateName(name);
        this.compound.addLong(name, value);
        return this;
    }

    public CompoundBuilder addTag(Tag<?> tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        CompoundBuilder.validateName(tag.getName());
        this.compound.addTag(tag);
        return this;
    }

    public ListBuilder addList(String name, NBTTags listType) {
        CompoundBuilder.validateName(name);
        return new ListBuilder(name, listType, this);
    }

    public CompoundBuilder addCompound(String name) {
        CompoundBuilder.validateName(name);
        return new CompoundBuilder(name, this);
    }

    public ICompoundTag build() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot build nested compound - call end() first to return to parent");
        }
        return this.compound;
    }

    @Override
    public NBTBuilder end() {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot end root builder - call build() instead");
        }
        NBTBuilder nBTBuilder = this.parent;
        if (nBTBuilder instanceof CompoundBuilder) {
            CompoundBuilder parentCompound = (CompoundBuilder)nBTBuilder;
            parentCompound.compound.addTag(this.compound);
            return parentCompound;
        }
        nBTBuilder = this.parent;
        if (nBTBuilder instanceof ListBuilder) {
            ListBuilder parentList = (ListBuilder)nBTBuilder;
            parentList.addBuiltTag(this.compound);
            return parentList;
        }
        throw new IllegalStateException("Unknown parent builder type");
    }

    public CompoundBuilder endCompound() {
        NBTBuilder parent = this.end();
        if (parent instanceof CompoundBuilder) {
            CompoundBuilder compound = (CompoundBuilder)parent;
            return compound;
        }
        throw new IllegalStateException("Parent is not a CompoundBuilder");
    }

    public ListBuilder endList() {
        NBTBuilder parent = this.end();
        if (parent instanceof ListBuilder) {
            ListBuilder list = (ListBuilder)parent;
            return list;
        }
        throw new IllegalStateException("Parent is not a ListBuilder");
    }

    protected Tag_Compound getCompound() {
        return this.compound;
    }
}

