/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.builder;

import de.pauleff.api.IListTag;
import de.pauleff.builder.CompoundBuilder;
import de.pauleff.builder.NBTBuilder;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Byte;
import de.pauleff.core.Tag_Float;
import de.pauleff.core.Tag_List;
import de.pauleff.core.Tag_Long;
import de.pauleff.core.Tag_Short;
import de.pauleff.util.NBTTags;
import java.util.ArrayList;

public class ListBuilder
extends NBTBuilder {
    private final Tag_List list;
    private final NBTTags listType;

    public ListBuilder(String name, NBTTags listType, NBTBuilder parent) {
        super(name, parent);
        ListBuilder.validateName(name);
        if (listType == null) {
            throw new IllegalArgumentException("List type cannot be null");
        }
        this.listType = listType;
        this.list = new Tag_List(name, listType.getId(), new ArrayList());
    }

    public ListBuilder addString(String name, String value) {
        this.validateListType(NBTTags.Tag_String);
        ListBuilder.validateName(name);
        this.list.addString(name, value);
        return this;
    }

    public ListBuilder addInt(String name, int value) {
        this.validateListType(NBTTags.Tag_Int);
        ListBuilder.validateName(name);
        this.list.addInt(name, value);
        return this;
    }

    public ListBuilder addDouble(String name, double value) {
        this.validateListType(NBTTags.Tag_Double);
        ListBuilder.validateName(name);
        this.list.addDouble(name, value);
        return this;
    }

    public ListBuilder addFloat(String name, float value) {
        this.validateListType(NBTTags.Tag_Float);
        ListBuilder.validateName(name);
        this.list.addTag(new Tag_Float(name, value));
        return this;
    }

    public ListBuilder addByte(String name, byte value) {
        this.validateListType(NBTTags.Tag_Byte);
        ListBuilder.validateName(name);
        this.list.addTag(new Tag_Byte(name, value));
        return this;
    }

    public ListBuilder addShort(String name, short value) {
        this.validateListType(NBTTags.Tag_Short);
        ListBuilder.validateName(name);
        this.list.addTag(new Tag_Short(name, value));
        return this;
    }

    public ListBuilder addLong(String name, long value) {
        this.validateListType(NBTTags.Tag_Long);
        ListBuilder.validateName(name);
        this.list.addTag(new Tag_Long(name, value));
        return this;
    }

    public CompoundBuilder addCompound(String name) {
        this.validateListType(NBTTags.Tag_Compound);
        ListBuilder.validateName(name);
        return new CompoundBuilder(name, this);
    }

    public ListBuilder addList(String name, NBTTags nestedListType) {
        this.validateListType(NBTTags.Tag_List);
        ListBuilder.validateName(name);
        return new ListBuilder(name, nestedListType, this);
    }

    protected void addBuiltTag(Tag<?> tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        NBTTags tagType = NBTTags.getById(tag.getId());
        if (tagType != this.listType) {
            throw new IllegalArgumentException(String.format("Tag type mismatch! List expects %s but got %s", this.listType.getName(), tagType.getName()));
        }
        this.list.addTag(tag);
    }

    public IListTag build() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot build nested list - call end() first to return to parent");
        }
        return this.list;
    }

    @Override
    public NBTBuilder end() {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot end root builder - call build() instead");
        }
        NBTBuilder nBTBuilder = this.parent;
        if (nBTBuilder instanceof CompoundBuilder) {
            CompoundBuilder parentCompound = (CompoundBuilder)nBTBuilder;
            parentCompound.getCompound().addTag(this.list);
            return parentCompound;
        }
        nBTBuilder = this.parent;
        if (nBTBuilder instanceof ListBuilder) {
            ListBuilder parentList = (ListBuilder)nBTBuilder;
            parentList.addBuiltTag(this.list);
            return parentList;
        }
        throw new IllegalStateException("Unknown parent builder type");
    }

    private void validateListType(NBTTags expectedType) {
        if (this.listType != expectedType) {
            throw new IllegalArgumentException(String.format("List type mismatch! Expected %s but list is of type %s", expectedType.getName(), this.listType.getName()));
        }
    }

    public CompoundBuilder endCompound() {
        NBTBuilder parent = this.end();
        if (parent instanceof CompoundBuilder) {
            CompoundBuilder compound = (CompoundBuilder)parent;
            return compound;
        }
        throw new IllegalStateException("Parent is not a CompoundBuilder");
    }

    public ListBuilder endList() {
        NBTBuilder parent = this.end();
        if (parent instanceof ListBuilder) {
            ListBuilder list = (ListBuilder)parent;
            return list;
        }
        throw new IllegalStateException("Parent is not a ListBuilder");
    }

    public NBTTags getListType() {
        return this.listType;
    }

    protected Tag_List getList() {
        return this.list;
    }
}

