/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.builder;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.ITag;
import de.pauleff.api.NBTFileFactory;
import de.pauleff.builder.CompoundBuilder;
import de.pauleff.builder.ListBuilder;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Byte;
import de.pauleff.core.Tag_Compound;
import de.pauleff.core.Tag_Double;
import de.pauleff.core.Tag_Float;
import de.pauleff.core.Tag_Int;
import de.pauleff.core.Tag_Long;
import de.pauleff.core.Tag_Short;
import de.pauleff.core.Tag_String;
import de.pauleff.formats.binary.Compression_Types;
import de.pauleff.util.NBTTags;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class NBTBuilder {
    protected String name;
    protected NBTBuilder parent;

    protected NBTBuilder(String name, NBTBuilder parent) {
        this.name = name;
        this.parent = parent;
    }

    public static CompoundBuilder compound(String name) {
        return new CompoundBuilder(name, null);
    }

    public static ListBuilder list(String name, NBTTags listType) {
        return new ListBuilder(name, listType, null);
    }

    public static ITag<String> string(String name, String value) {
        NBTBuilder.validateName(name);
        return new Tag_String(name, value);
    }

    public static ITag<Integer> integer(String name, int value) {
        NBTBuilder.validateName(name);
        return new Tag_Int(name, value);
    }

    public static ITag<Double> doubleTag(String name, double value) {
        NBTBuilder.validateName(name);
        return new Tag_Double(name, value);
    }

    public static ITag<Float> floatTag(String name, float value) {
        NBTBuilder.validateName(name);
        return new Tag_Float(name, value);
    }

    public static ITag<Byte> byteTag(String name, byte value) {
        NBTBuilder.validateName(name);
        return new Tag_Byte(name, value);
    }

    public static ITag<Short> shortTag(String name, short value) {
        NBTBuilder.validateName(name);
        return new Tag_Short(name, value);
    }

    public static ITag<Long> longTag(String name, long value) {
        NBTBuilder.validateName(name);
        return new Tag_Long(name, value);
    }

    protected static void validateName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Tag name cannot be null or empty");
        }
    }

    public static CompoundBuilder fromFile(File file) throws IOException {
        ICompoundTag loadedData = NBTFileFactory.readNBTFile(file);
        CompoundBuilder builder = new CompoundBuilder(loadedData.getName(), null);
        if (loadedData instanceof Tag_Compound) {
            Tag_Compound concrete = (Tag_Compound)loadedData;
            for (Tag tag : (ArrayList)concrete.getData()) {
                builder.addTag(tag);
            }
        }
        return builder;
    }

    public abstract ITag<?> build();

    public abstract NBTBuilder end();

    public String getName() {
        return this.name;
    }

    public NBTBuilder getParent() {
        return this.parent;
    }

    public void buildAndSave(File file) throws IOException {
        if (this.parent != null) {
            throw new IllegalStateException("buildAndSave() can only be called on root builders");
        }
        ITag<?> result = this.build();
        if (!(result instanceof ICompoundTag)) {
            throw new IllegalStateException("Root NBT structure must be a compound tag");
        }
        ICompoundTag compoundTag = (ICompoundTag)result;
        NBTFileFactory.writeNBTFile(file, compoundTag);
    }

    public void buildAndSave(File file, Compression_Types compression) throws IOException {
        if (this.parent != null) {
            throw new IllegalStateException("buildAndSave() can only be called on root builders");
        }
        ITag<?> result = this.build();
        if (!(result instanceof ICompoundTag)) {
            throw new IllegalStateException("Root NBT structure must be a compound tag");
        }
        ICompoundTag compoundTag = (ICompoundTag)result;
        NBTFileFactory.writeNBTFile(file, compoundTag, compression);
    }
}

