/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.core;

import de.pauleff.api.ITag;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Collection_Tag
extends Tag<ArrayList<Tag<?>>> {
    public Collection_Tag(int id) {
        super(id, null, new ArrayList());
    }

    public Collection_Tag(int id, String name) {
        super(id, name, new ArrayList());
    }

    public Collection_Tag(int id, String name, ArrayList<Tag<?>> data) {
        super(id, name, data);
    }

    public Collection_Tag addTag(ITag<?> tag) {
        Collection_Tag collection_Tag = this;
        if (collection_Tag instanceof Tag_List) {
            Tag_List list = (Tag_List)collection_Tag;
            if (tag.getId() != list.getListTypeID()) {
                throw new IllegalArgumentException(String.format("Mixed datatypes! Expected %d but got %d", list.getListTypeID(), tag.getId()));
            }
        }
        ((ArrayList)this.getData()).add((Tag)tag);
        return this;
    }

    public Collection_Tag addAllTags(List<Tag<?>> tags) {
        Collection_Tag collection_Tag = this;
        if (collection_Tag instanceof Tag_List) {
            Tag_List list = (Tag_List)collection_Tag;
            for (Tag tag : tags) {
                if (tag.getId() == list.getListTypeID()) continue;
                throw new IllegalArgumentException(String.format("Mixed datatypes!. Expected %d but got %d", this.getId(), tag.getId()));
            }
        }
        ((ArrayList)this.getData()).addAll(tags);
        return this;
    }

    public List<Tag<?>> getAllTagsByName(String name) {
        return this.getTagsByName(name, true);
    }

    public Tag<?> getTagByName(String name) {
        return this.getTagsByName(name, false).stream().findFirst().orElse(null);
    }

    private List<Tag<?>> getTagsByName(String name, boolean global) {
        ArrayList tags = new ArrayList();
        for (Tag tag : (ArrayList)this.getData()) {
            if (tag.getName().equals(name)) {
                tags.add(tag);
                if (global) continue;
                return tags;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            tags.addAll(collectionTag.getTagsByName(name, global));
        }
        return tags;
    }

    public List<Tag<?>> getAllTags(Tag<?> targetTag) {
        return this.getTags(targetTag, true);
    }

    public Tag<?> getTag(Tag<?> targetTag) {
        return this.getTags(targetTag, false).stream().findFirst().orElse(null);
    }

    private List<Tag<?>> getTags(Tag<?> targetTag, boolean global) {
        ArrayList tags = new ArrayList();
        for (Tag tag : (ArrayList)this.getData()) {
            if (tag.equals(targetTag)) {
                tags.add(tag);
                if (global) continue;
                return tags;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            tags.addAll(collectionTag.getTags(targetTag, global));
        }
        return tags;
    }

    public void removeAllTagsByName(String name) {
        this.removeTagsByName(name, true);
    }

    public Collection_Tag removeTagByName(String name) {
        this.removeTagsByName(name, false);
        return this;
    }

    private void removeTagsByName(String name, boolean global) {
        Iterator iterator = ((ArrayList)this.getData()).iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tag.getName().equals(name)) {
                iterator.remove();
                if (global) continue;
                return;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            collectionTag.removeTagsByName(name, global);
        }
    }

    public void removeAllTags(Tag<?> targetTag) {
        this.removeTags(targetTag, true);
    }

    public Collection_Tag removeTag(Tag<?> targetTag) {
        this.removeTags(targetTag, false);
        return this;
    }

    private void removeTags(Tag<?> targetTag, boolean global) {
        Iterator iterator = ((ArrayList)this.getData()).iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tag.equals(targetTag)) {
                iterator.remove();
                if (global) continue;
                return;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            collectionTag.removeTags(targetTag, global);
        }
    }
}

