/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.core;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.core.Collection_Tag;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Byte;
import de.pauleff.core.Tag_Double;
import de.pauleff.core.Tag_Float;
import de.pauleff.core.Tag_Int;
import de.pauleff.core.Tag_List;
import de.pauleff.core.Tag_Long;
import de.pauleff.core.Tag_Short;
import de.pauleff.core.Tag_String;
import de.pauleff.util.NBTTags;
import java.util.ArrayList;

public class Tag_Compound
extends Collection_Tag
implements ICompoundTag {
    public Tag_Compound() {
        super(NBTTags.Tag_Compound.getId());
    }

    public Tag_Compound(String name) {
        super(NBTTags.Tag_Compound.getId(), name);
    }

    public Tag_Compound(String name, ArrayList<Tag<?>> data) {
        super(NBTTags.Tag_Compound.getId(), name, data);
    }

    @Override
    public ICompoundTag addString(String name, String value) {
        this.addTag(new Tag_String(name, value));
        return this;
    }

    @Override
    public ICompoundTag addInt(String name, int value) {
        this.addTag(new Tag_Int(name, value));
        return this;
    }

    @Override
    public ICompoundTag addDouble(String name, double value) {
        this.addTag(new Tag_Double(name, value));
        return this;
    }

    @Override
    public ICompoundTag addFloat(String name, float value) {
        this.addTag(new Tag_Float(name, value));
        return this;
    }

    @Override
    public ICompoundTag addByte(String name, byte value) {
        this.addTag(new Tag_Byte(name, value));
        return this;
    }

    @Override
    public ICompoundTag addShort(String name, short value) {
        this.addTag(new Tag_Short(name, value));
        return this;
    }

    @Override
    public ICompoundTag addLong(String name, long value) {
        this.addTag(new Tag_Long(name, value));
        return this;
    }

    @Override
    public boolean hasTag(String tagName) {
        return this.getTagByName(tagName) != null;
    }

    @Override
    public ITag<?> getTag(String name) {
        return this.getTagByName(name);
    }

    @Override
    public String getString(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_String) {
            return (String)tag.getData();
        }
        return null;
    }

    @Override
    public int getInt(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_Int) {
            return (Integer)tag.getData();
        }
        return 0;
    }

    @Override
    public double getDouble(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_Double) {
            return (Double)tag.getData();
        }
        return 0.0;
    }

    @Override
    public byte getByte(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_Byte) {
            return (Byte)tag.getData();
        }
        return 0;
    }

    @Override
    public ICompoundTag getCompound(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_Compound) {
            return (ICompoundTag)((Object)tag);
        }
        return null;
    }

    @Override
    public IListTag getList(String name) {
        Tag<?> tag = this.getTagByName(name);
        if (tag instanceof Tag_List) {
            return (IListTag)((Object)tag);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NBTTags.Tag_Compound.getName());
        sb.append("(name=").append(this.getName()).append(", size=").append(((ArrayList)this.getData()).size()).append("):");
        for (Tag tag : (ArrayList)this.getData()) {
            sb.append("\n  ").append(tag.toString().replace("\n", "\n  "));
        }
        sb.append("\n").append(NBTTags.Tag_End.getName());
        sb.append("(name=").append(this.getName()).append(")");
        return sb.toString();
    }
}

