/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.core;

import de.pauleff.api.IListTag;
import de.pauleff.core.Collection_Tag;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Compound;
import de.pauleff.core.Tag_Double;
import de.pauleff.core.Tag_Int;
import de.pauleff.core.Tag_String;
import de.pauleff.util.NBTTags;
import java.util.ArrayList;

public class Tag_List
extends Collection_Tag
implements IListTag {
    private final int listTypeID;

    public Tag_List(int listTypeID) {
        super(NBTTags.Tag_List.getId());
        this.listTypeID = listTypeID;
    }

    public Tag_List(String name, int listTypeID) {
        super(NBTTags.Tag_List.getId(), name);
        this.listTypeID = listTypeID;
    }

    public Tag_List(String name, int listTypeID, ArrayList<Tag<?>> data) {
        super(NBTTags.Tag_List.getId(), name, data);
        this.listTypeID = listTypeID;
    }

    @Override
    public int getListTypeID() {
        return this.listTypeID;
    }

    @Override
    public IListTag addString(String name, String value) {
        this.addTag(new Tag_String(name, value));
        return this;
    }

    @Override
    public IListTag addInt(String name, int value) {
        this.addTag(new Tag_Int(name, value));
        return this;
    }

    @Override
    public IListTag addDouble(String name, double value) {
        this.addTag(new Tag_Double(name, value));
        return this;
    }

    @Override
    public IListTag addCompound(String name) {
        this.addTag(new Tag_Compound(name));
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NBTTags.Tag_List.getName());
        sb.append("(name=").append(this.getName()).append(", type=").append(this.getListTypeID()).append(", size=").append(((ArrayList)this.getData()).size()).append("):");
        for (Tag tag : (ArrayList)this.getData()) {
            sb.append("\n  ").append(tag.toString().replace("\n", "\n  "));
        }
        sb.append("\n").append(NBTTags.Tag_End.getName());
        sb.append("(name=").append(this.getName()).append(")");
        return sb.toString();
    }
}

