/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.examples;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.api.NBTFactory;
import de.pauleff.api.NBTFileFactory;
import de.pauleff.util.NBTTags;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class BasicOperationsExample {
    public static void main(String[] args) throws IOException {
        System.out.println("=== Basic NBT Operations ===\n");
        ITag<String> name = NBTFactory.createString("playerName", "Steve");
        ITag<Integer> level = NBTFactory.createInt("level", 42);
        ITag<Double> health = NBTFactory.createDouble("health", 20.0);
        System.out.println("Created tags:");
        System.out.println("\t" + String.valueOf(name));
        System.out.println("\t" + String.valueOf(level));
        System.out.println("\t" + String.valueOf(health));
        ICompoundTag player = NBTFactory.createCompound("Player").addString("name", "Steve").addInt("level", 42).addDouble("health", 20.0).addByte("gameMode", (byte)1);
        System.out.println("\nCompound tag created with " + ((ArrayList)player.getData()).size() + " fields");
        String playerName = player.getString("name");
        int playerLevel = player.getInt("level");
        double playerHealth = player.getDouble("health");
        System.out.println("Player: " + playerName + " (Level " + playerLevel + ", Health " + playerHealth + ")");
        int nameAsInt = player.getInt("name");
        String missingField = player.getString("missing");
        System.out.println("Type safety: name as int = " + nameAsInt + ", missing field = " + missingField);
        IListTag inventory = NBTFactory.createList("inventory", NBTTags.Tag_String.getId());
        inventory.addString("item1", "sword").addString("item2", "shield");
        System.out.println("Inventory list type: " + inventory.getListTypeID() + " (size: " + ((ArrayList)inventory.getData()).size() + ")");
        File testFile = new File("./basic_test.dat");
        NBTFileFactory.writeNBTFile(testFile, player);
        System.out.println("Wrote player data to file (" + testFile.length() + " bytes)");
        ICompoundTag loadedPlayer = NBTFileFactory.readNBTFile(testFile);
        System.out.println("Loaded player: " + loadedPlayer.getString("name"));
        boolean success = testFile.delete();
        System.out.printf("Cleanup %s%n", success ? "succeeded" : "failed");
    }
}

