/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.examples;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.api.NBTFileFactory;
import de.pauleff.builder.ListBuilder;
import de.pauleff.builder.NBTBuilder;
import de.pauleff.core.Tag;
import de.pauleff.formats.binary.Compression_Types;
import de.pauleff.util.NBTTags;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class BuilderPatternExample {
    public static void main(String[] args) throws IOException {
        System.out.println("=== Builder Pattern Example ===\n");
        System.out.println("1. Simple compound (no nesting):");
        ICompoundTag gameData = NBTBuilder.compound("GameData").addString("name", "MyWorld").addInt("version", 2).addDouble("difficulty", 1.5).build();
        System.out.println("\tBuilt compound: " + gameData.getString("name"));
        System.out.println("\n2. Single-level nesting - end() for terminal operations:");
        ICompoundTag simplePlayer = (ICompoundTag)NBTBuilder.compound("SimplePlayer").addString("name", "Bob").addString("class", "warrior").addCompound("stats").addInt("level", 10).addDouble("health", 20.0).end().build();
        System.out.println("\tSimple player: " + simplePlayer.getString("name"));
        System.out.println("\n3. Complex chaining - using type-safe end methods:");
        ICompoundTag playerData = NBTBuilder.compound("Player").addString("name", "Alice").addInt("level", 25).addList("inventory", NBTTags.Tag_Compound).addCompound("item1").addString("type", "sword").addInt("damage", 10).endList().addCompound("item2").addString("type", "potion").addInt("healing", 5).endList().endCompound().addString("lastLogin", "2024-01-01").build();
        System.out.println("\tComplex player: " + playerData.getString("name"));
        IListTag inventory = playerData.getList("inventory");
        if (inventory != null) {
            System.out.println("\tInventory items: " + ((ArrayList)inventory.getData()).size());
        }
        System.out.println("\n4. Variable storage pattern (alternative approach):");
        IListTag separateInventory = BuilderPatternExample.createInventoryList();
        ICompoundTag variablePlayer = NBTBuilder.compound("VariablePlayer").addString("name", "Charlie").addTag((Tag)((Object)separateInventory)).build();
        System.out.println("\tVariable player: " + variablePlayer.getString("name"));
        System.out.println("\n5. File integration (simple structure):");
        File configFile = new File("./config.dat");
        NBTBuilder.compound("ServerConfig").addString("serverName", "Test Server").addInt("maxPlayers", 20).addByte("pvp", (byte)1).buildAndSave(configFile, Compression_Types.GZIP);
        System.out.println("\tConfig saved to file (" + configFile.length() + " bytes)");
        NBTBuilder.fromFile(configFile).addString("motd", "Welcome!").addLong("lastModified", System.currentTimeMillis()).buildAndSave(configFile);
        ICompoundTag loadedConfig = NBTFileFactory.readNBTFile(configFile);
        System.out.println("\tModified config MOTD: " + loadedConfig.getString("motd"));
        System.out.println("\n6. Static factory methods (no builders needed):");
        ITag<String> title = NBTBuilder.string("title", "Example");
        ITag<Integer> count = NBTBuilder.integer("count", 100);
        System.out.println("\tStatic factories: " + title.getData() + ", " + String.valueOf(count.getData()));
        configFile.delete();
        System.out.println("\nCleanup completed");
    }

    private static IListTag createInventoryList() {
        ListBuilder listBuilder = NBTBuilder.list("inventory", NBTTags.Tag_Compound);
        listBuilder.addCompound("item1").addString("type", "sword").addInt("damage", 10).end();
        listBuilder.addCompound("item2").addString("type", "potion").addInt("healing", 5).end();
        return listBuilder.build();
    }
}

