/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.binary;

public enum Compression_Types {
    NONE(0, "NONE"),
    GZIP(1, "GZIP"),
    ZLIB(2, "ZLIB"),
    LZ4(3, "LZ4");

    private static final Compression_Types[] ID_LOOKUP;
    private final int id;
    private final String compressionType;

    private Compression_Types(int id, String compressionType) {
        this.id = id;
        this.compressionType = compressionType;
    }

    public static Compression_Types getById(int id) {
        return id >= 0 && id < ID_LOOKUP.length ? ID_LOOKUP[id] : null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.compressionType;
    }

    static {
        ID_LOOKUP = new Compression_Types[4];
        Compression_Types[] compression_TypesArray = Compression_Types.values();
        int n = compression_TypesArray.length;
        for (int i = 0; i < n; ++i) {
            Compression_Types type;
            Compression_Types.ID_LOOKUP[type.id] = type = compression_TypesArray[i];
        }
    }
}

